#include<math.h>
#include<stdio.h>
void InitXArray(void);

struct TPoint   {
                 double X;
                 double Y;
                 double Z;
                } R00;
struct TPinInfo {
                 double BX;
                 double BZ;
                 double EX;
                 double EZ;
                 double Angle;
                };
struct TIndex   {
                 int L;
                 int R;
                };

//const double Length      =   10.00;
//const double WidthMid    =    3.80;
//const double Height      =    1.00;
//const double AngleXY     =   20.00;
//const double AngleYZ     =  -20.00;
//const        PinNumber   =      16;
//const double PinHeight   =    1.20;
//const double PinPeak     = PinHeight + 0.30;
//const double PinWidth    =    0.60;
//const double PinOffset   =    0.40;
//const double PlugOffset  =    0.50;
//const double PlugWidth   = 0.6*PinWidth;
//const double JumpHeight  =    1.00;
//const double Periode     = 1.2*Length;
//const double StartPhase  =   10.00;
//const GIF_Number         =       1;
const int MaxOrder  =      10;            // the value 0 is allowed!
const int MaxPins   =      40;
const int MaxPoints = (2 + MaxOrder)*(0.5*MaxPins + 1);//don't change!
const double pi = 3.14159265358979;

double Delta,PinDis,Phase,ActICMidPoint;
double XArrayMid[MaxPoints],ZArrayMid[MaxPoints];
double XArrayTop[MaxPoints],ZArrayTop[MaxPoints];
double XArrayBut[MaxPoints],ZArrayBut[MaxPoints];
double XArrayPin[MaxPoints],ZArrayPin[MaxPoints];
double ActPosX,BetweenPin,AngleXY,AngleYZ,OldDistance,WidthEdge;
double Length,WidthMid,Height,PinHeight,PinPeak,PinWidth,PinOffset;
double PlugOffset,PlugWidth,JumpHeight,Periode,StartPhase,FrameWidth;
int PinNumber,PolygonOrder,PointsOnLength,MaxPictures;
TPinInfo PinInfo[MaxPins];
int WriteCounter,ActIndex,IntCounter,actsign;

void SetDefaultValue(void)
{
 MaxPictures    =      10;
 PinNumber      =      16;
 Length         =   10.00;
 WidthMid       =    3.00;
 WidthEdge      = WidthMid - 0.30;
 Height         =    1.00;
 PinHeight      =    1.00;
 PinPeak        = PinHeight + 0.20;
 PinWidth       =    0.60;
 PinOffset      =    0.20;
 PlugOffset     =    0.50;
 PlugWidth      =    0.25;
 JumpHeight     =    0.00;//1.50;
 Periode        =    1.20*Length;
 StartPhase     =   80.00;//10.00;
 AngleXY        =   90.00;
 AngleYZ        =    0.00;;
 FrameWidth     = 1.25*Length;//14.00;
 R00.X          = 0.5*FrameWidth;
 R00.Y          = 0.5*FrameWidth;
 R00.Z          = 0.5*FrameWidth;
 PolygonOrder   =      2; // error in picture if  = 0!!
 PointsOnLength = (2 + PolygonOrder)*(0.5*PinNumber + 1);
}

void ResetAllArrays(void)
{
  int raa;

  for (raa = 0; raa <= PointsOnLength -1; raa++)
  {
    XArrayBut[raa] = 0.00;
    ZArrayBut[raa] = 0.00;
    XArrayMid[raa] = 0.00;
    ZArrayMid[raa] = 0.00;
    XArrayTop[raa] = 0.00;
    ZArrayTop[raa] = 0.00;
  }
}

double GetCOS(double GC)
{
  return JumpHeight*0.5*(1 + cos(2*pi*(GC/Periode + Phase/360.00)));
}

double ErrFunc(double EFX0, double EFY0, double EFX, double EFDeltaX)
{
  double dummy,yef;

  yef   = GetCOS(EFX);
  dummy = (EFX0 - EFX)*(EFX0 - EFX) + (EFY0 - yef)*(EFY0 - yef);
  dummy = dummy - EFDeltaX*EFDeltaX;
  return dummy;
}

double NextPosition(double NP_OldX, int sign, double NP_DeltaX)
{
 double ErrL,ErrM,XL,XM,XR,StartX,X0,Y0,ActError;
            //        to left                    to right
 StartX = -JumpHeight*0.5*sin(2*pi*(NP_OldX/Periode + Phase/360.00)); // slope
 StartX = atan(StartX*2*pi/Periode); // angle at x = NP_OldX
 StartX = NP_OldX + sign*NP_DeltaX*cos(StartX);
 StartX = StartX + 2*(StartX - NP_OldX); // should work!
 if (sign == -1)
 {
   XL = StartX;
   XR = NP_OldX;
   X0 = NP_OldX;
 }
 else
 {
   XL = NP_OldX;
   XR = StartX;
   X0 = NP_OldX;
 } // if (sign == -1)
 Y0 = GetCOS(X0);
 do
 {
   ErrL = ErrFunc(X0,Y0,XL,NP_DeltaX);
   XM = 0.5*(XL + XR);
   ErrM = ErrFunc(X0,Y0,XM,NP_DeltaX);
   if (ErrL*ErrM > 0)
   {
     XL = XM;
     XR = XR;
   }
   else
   {
     XL = XL;
     XR = XM;
   }
   ActError = fabs((XR - XL)/XM);
 } // do
 while (ActError > 1E-8);
 return XM;
}

double GetFirstX_EVEN(int sign, double GF_DeltaX)
{
  double StepN,StepP,ActXN,ActXP,ActYN,ActFstError;
  double SaveErrorP,StartXP,fstres;
  int FirstP;

  SaveErrorP = 0.00;
  ActXN      = ActICMidPoint - 0.5*Delta; //+++
  ActYN      = GetCOS(ActXN);
  ActXP      = ActXN;
  StartXP    = ActXP;
  StepN      = ceil(GF_DeltaX)/10.00;
  StepP      = StepN;
  do
  {
    FirstP = 1;
    do
    {
      ActXP = ActXP + StepP;
      ActFstError = ErrFunc(ActXN,ActYN,ActXP,GF_DeltaX);
      if (FirstP != 1)
      {
        if (SaveErrorP*ActFstError < 0)
        {
         ActXP  = ActXP - 2*StepP;
         StepP  = StepP/10.00;
         FirstP = 1;
        }
      }
      else
      {
        if (ActFstError > 0)
        {
          ActXP = StartXP;
          StepP = StepP/10.00;
        }
        else
        {
          FirstP = 0;
        }
      }
      SaveErrorP = ActFstError;
    }
    while (StepP > 1E-8);
    if ((ActXP - ActICMidPoint) > (ActICMidPoint - ActXN))
    {
      ActXN = ActXN - StepN;
    }
    else
    {
      ActXN = ActXN + 2*StepN;
      StepN = StepN/10.00;
    }
    ActXP  = ActICMidPoint;
    StepP  = ceil(GF_DeltaX)/10.00;
    ActYN  = GetCOS(ActXN);
  }
  while (StepN > 1E-8);
  if (sign==1) fstres = ActXN + 2*(ActICMidPoint - ActXN); else fstres = ActXN;
  return fstres;
}

void InitXArrayMid(void)
{
  int ix; // first the midpoint, then to left an then to right ...

  //Phase  = StartPhase;
  Delta = Length/(PointsOnLength - 1.00);
  if (fmod(PointsOnLength,2.00) == 0.00) // the number of points is even
  {
    for (ix = 0.5*(PointsOnLength - 0) - 1; ix >= 0; ix--)
    {
      if (ix == 0.5*PointsOnLength - 0 - 1)
      {
        XArrayMid[ix] = GetFirstX_EVEN(-1,Delta);
      }
      else
      {
        XArrayMid[ix] = NextPosition(XArrayMid[ix+1],-1,Delta); // to  left
      }
    }
    for (ix = 0.5*(PointsOnLength + 0) + 0 ; ix < PointsOnLength; ix++)
    {
      if (ix == 0.5*PointsOnLength + 0 + 0)
      {
        XArrayMid[ix] = GetFirstX_EVEN(+1,Delta);
      }
      else
      {
        XArrayMid[ix] = NextPosition(XArrayMid[ix-1],+1,Delta);  // to right
      }
    }
  }
  else                                   // the number of points is  odd
  {
  }
} // void InitXArrayMid(void)

double GetAngle(struct TPoint GAL, struct TPoint GAM, struct TPoint GAR,
                char GBorder)
{
  double SlopeL,SlopeM,SlopeR;

  if (GBorder == 'M')
  {
   SlopeL = (GAM.Z - GAL.Z)/(GAM.X - GAL.X);
   SlopeR = (GAR.Z - GAM.Z)/(GAR.X - GAM.X);
  }
  else // one of the two endpoints ...
  {
    if (GBorder == 'L') // here is GAL = GAM
    {
      SlopeR = (GAR.Z - GAM.Z)/(GAR.X - GAM.X);
      SlopeL = SlopeR;
    }
    else               // here is GAM = GAR
    {
      SlopeL = (GAM.Z - GAL.Z)/(GAM.X - GAL.X);
      SlopeR = SlopeL;
    } // if (Border == 'L')
  } // if (Border == 'M')
  SlopeM = 0.5*(SlopeL + SlopeR);
  return 180/pi*atan(SlopeM);
}

void InitXArrayAndZArrayTopButtom(void)
{
  int lauf;
  char Border;
  struct TPoint PktL,PktM,PktR;
  double Angle;

  for (lauf = 0; lauf <= PointsOnLength - 1; lauf++)
  {
    PktM.X = XArrayMid[lauf];
    PktM.Y =            0.00; // set to zero
    PktM.Z = ZArrayMid[lauf];

    if ((lauf != 0) && (lauf != PointsOnLength - 1))
    {
      PktL.X = XArrayMid[lauf - 1];
      PktL.Y =                0.00; // set to zero
      PktL.Z = ZArrayMid[lauf - 1];

      PktR.X = XArrayMid[lauf + 1];
      PktR.Y =                0.00; // set to zero
      PktR.Z = ZArrayMid[lauf + 1];

      Border = 'M';
    }
    else // one of the two endpoints ...
    {
      if (lauf == 0) // set PktL = PktM at the  left endpoint
      {
        PktL = PktM;

        PktR.X = XArrayMid[lauf + 1];
        PktR.Y =                0.00;
        PktR.Z = ZArrayMid[lauf + 1];

        Border = 'L';
      }
      else           // set PktM = PktR at the right endpoint;
      {
        PktL.X = XArrayMid[lauf - 1];
        PktL.Y =                0.00;
        PktL.Z = ZArrayMid[lauf - 1];

        PktR = PktM;

        Border = 'R';
      }
    }
    Angle = GetAngle(PktL,PktM,PktR,Border);
    //DD = - 0.5*Height*sin(pi/180.00*Angle);
    XArrayTop[lauf] =  XArrayMid[lauf] - 0.5*Height*sin(pi/180.00*Angle);
    //DD = + 0.5*Height*sin(pi/180.00*Angle);
    ZArrayTop[lauf] =  ZArrayMid[lauf] + 0.5*Height*cos(pi/180.00*Angle);
    XArrayBut[lauf] =  XArrayMid[lauf] + 0.5*Height*sin(pi/180.00*Angle);
    ZArrayBut[lauf] =  ZArrayMid[lauf] - 0.5*Height*cos(pi/180.00*Angle);
  } // for (lauf = 0; lauf <= PointsOnLength - 1; lauf++)
} // void InitXArrayAndZArrayTopButtom(void);

struct TMidInfo {
                  double Angle;
                  double Prozent;
                  int Index;
                };

struct TPointXZ {
                  double X;
                  double Z;
                };

struct TMidInfo GetPinAngle(int GAP)
{
  double Slope,PinPos;
  struct TMidInfo DummyInfo;
  int GIndex;

  PinPos = GAP*(BetweenPin + PinWidth) + BetweenPin + 0.5*PinWidth;
  GIndex = floor(PinPos/Delta);
  Slope = (ZArrayMid[GIndex + 1] - ZArrayMid[GIndex])/
          (XArrayMid[GIndex + 1] - XArrayMid[GIndex]);
  DummyInfo.Prozent = 100.00*(PinPos - GIndex*Delta)/Delta;
  DummyInfo.Index = GIndex;
  DummyInfo.Angle = 180.00/pi*atan(Slope);
  return DummyInfo;
}

struct TPointXZ GetH(struct TPointXZ GH0, struct TPointXZ GHR, double Alpha)
{
  double Beta,Gamma,sqrd,sqrp,sqrsin,h1,h2,si,co;
  struct TPointXZ DummyH;

  sqrp   = 0.25*PinWidth*PinWidth;
  sqrd   = (GHR.Z - GH0.Z)*(GHR.Z - GH0.Z) + (GHR.X - GH0.X)*(GHR.X - GH0.X);
  Beta   = (GHR.Z - GH0.Z)/(GHR.X - GH0.X);
  Beta   = 180.00/pi*atan(Beta);
  Gamma  = 90.00 + Alpha - Beta;
  sqrsin = sin(pi/180.00*Gamma); sqrsin = sqrsin*sqrsin;
  if (fabs(sqrsin) - 1 < 1E-8)
  { // sin(Gamma = 1)
    h2 = sqrt(sqrp - sqrd);
  }
  else
  { // sin(Gamma) <> 1
    h1 = sqrd - sqrp; h1 = h1*h1;
    h2 = sqrd + sqrp - 2*sqrd*sqrsin;
    if (h2 < 0) printf("Fehler!!");
    if (fabs(h2*h2/h1) - 1 > 1E-10 ) h2 = sqrt(h2 + sqrt(h2*h2 - h1));
                                else h2 = sqrt(h2);
  }
  si = fabs(sin(pi/180.00*Alpha));
  co = fabs(cos(pi/180.00*Alpha));
  if (Alpha < 0)
  {
    DummyH.X = GH0.X - h2*si;
    DummyH.Z = GH0.Z - h2*co;
  }
  else
  {
    DummyH.X = GH0.X + h2*si;
    DummyH.Z = GH0.Z - h2*co;
  }
  return DummyH;
}

double GetAbstand(struct TPointXZ GAPkt, struct TPointXZ G0Pkt, int GAIndex)
{
  float DummyA,hx,hz,acta,olda,aa,bb,cc,pp;
  int First,Found;

  First = 1; Found = 0; olda = 0.00;
  do
  {
    hx   = XArrayMid[GAIndex] - GAPkt.X; hx = hx*hx;
    hz   = ZArrayMid[GAIndex] - GAPkt.Z; hz = hz*hz;
    acta = sqrt(hx + hz);
    if (First == 0)
    {
      if (olda < acta)
      {
        Found = 1;
        GAIndex++;
      }
    }
    else
    {
      First = 0;
    }
    olda = acta;
    GAIndex--;
  }
  while (Found == 0);
  GAPkt.X = GAPkt.X + GAPkt.X - G0Pkt.X;
  GAPkt.Z = GAPkt.Z + GAPkt.Z - G0Pkt.Z;
  hx = GAPkt.X - XArrayMid[GAIndex    ]; hz = GAPkt.Z - ZArrayMid[GAIndex    ];
  aa = hx*hx + hz*hz;
  hx = GAPkt.X - XArrayMid[GAIndex + 1]; hz = GAPkt.Z - ZArrayMid[GAIndex + 1];
  bb = hx*hx + hz*hz;
  hx = XArrayMid[GAIndex] - XArrayMid[GAIndex + 1];
  hz = ZArrayMid[GAIndex] - ZArrayMid[GAIndex + 1];
  cc = hx*hx + hz*hz;  // cc rausschmeien: cc = Delta!
  pp = 0.5*(cc - aa - bb); pp = pp*pp;
  DummyA = (aa*bb - pp)/cc;
  DummyA = fabs(DummyA);
  DummyA = sqrt(DummyA);
  return DummyA;
}

struct TPointXZ GetPointXZ(struct TMidInfo MidInfo)
{
  struct TPointXZ Pkt0,RBeg,REnd,ActR,PktH;
  double StepR,ActAngle,Abstand,hx,hz;
  int ActSegment;

  RBeg.X = XArrayMid[MidInfo.Index    ]; RBeg.Z = ZArrayMid[MidInfo.Index    ];
  REnd.X = XArrayMid[MidInfo.Index + 1]; REnd.Z = ZArrayMid[MidInfo.Index + 1];
  ActAngle = MidInfo.Angle;
  Pkt0.X = RBeg.X + MidInfo.Prozent/100.00*(REnd.X - RBeg.X);
  Pkt0.Z = RBeg.Z + MidInfo.Prozent/100.00*(REnd.Z - RBeg.Z);
  ActSegment = MidInfo.Index; ActR.X = Pkt0.X; ActR.Z = Pkt0.Z;
  StepR = 0.1*ceil(Delta); IntCounter = 0; actsign = 1; OldDistance = 1E+32;
  do // the X-loop ...
 {
  IntCounter++;
   ActR.X = ActR.X + actsign*StepR*cos(pi/180.00*ActAngle);
   ActR.Z = ActR.Z + actsign*StepR*sin(pi/180.00*ActAngle);
   hx     = ActR.X - Pkt0.X; hx = hx*hx;
   hz     = ActR.Z - Pkt0.Z; hz = hz*hz;
   if (sqrt(hx + hz) > 0.5*PinWidth)
   {
     ActR.X = ActR.X - actsign*StepR*cos(pi/180.00*ActAngle);
     ActR.Z = ActR.Z - actsign*StepR*sin(pi/180.00*ActAngle);
     StepR = 0.1*StepR;
   };

   if (ActR.X > REnd.X)
   { // go to the next segment ...
     ActSegment++;
     RBeg = REnd;
     REnd.X = XArrayMid[ActSegment + 1];
     REnd.Z = ZArrayMid[ActSegment + 1];
     ActR = RBeg; // set ActR to the begin of the segment
   }
   ActAngle = 180.00/pi*atan((Pkt0.Z - RBeg.Z)/(Pkt0.X - RBeg.X));
   PktH    = GetH(Pkt0,ActR,MidInfo.Angle);
   Abstand = GetAbstand(PktH,ActR,MidInfo.Index);
   if (OldDistance < Abstand)
   {
     ActR.X = ActR.X - actsign*StepR*cos(pi/180.00*ActAngle);
     ActR.Z = ActR.Z - actsign*StepR*sin(pi/180.00*ActAngle);
     actsign = -actsign;
     StepR = 0.1*StepR;
   }
   OldDistance = Abstand;
 }
 while (IntCounter < 100);
 ActR.X = ActR.X - actsign*StepR*cos(pi/180.00*ActAngle);
 ActR.Z = ActR.Z - actsign*StepR*sin(pi/180.00*ActAngle);
 return ActR;
}

int DistanceOK(double OKMX, double OKMZ, double OKPX, double OKPZ)
{
  int dummyok;
  double hx,hz;

  hx = OKPX - OKMX; hx = hx*hx;
  hz = OKPZ - OKMZ; hz = hz*hz;
  if (sqrt(hx + hz) >= 0.5*Delta) dummyok = 1; else dummyok = 0;
  return dummyok;
}

void InitXZArrayMidForPins(void)
{
  int pin,Leave;
  double si,co;
  struct TMidInfo MidInfo;
  struct TPointXZ XZBeg,XZEnd;
  
  BetweenPin = (Length - 0.5*PinNumber*PinWidth)/(0.5*PinNumber + 1);
  WriteCounter = -1; ActIndex = -1;
  for (pin = 0; pin <= 0.5*PinNumber - 1; pin++)
  {
    Leave = 0;
    MidInfo = GetPinAngle(pin);
    PinInfo[pin].Angle = MidInfo.Angle;
    XZEnd = GetPointXZ(MidInfo);
    si = fabs(sin(pi/180.00*MidInfo.Angle));
    co = fabs(cos(pi/180.00*MidInfo.Angle));
    if (MidInfo.Angle < 0)
    {
      XZBeg.X = XZEnd.X - PinWidth*co;
      XZBeg.Z = XZEnd.Z + PinWidth*si;
    }
    else
    {
      XZBeg.X = XZEnd.X - PinWidth*co;
      XZBeg.Z = XZEnd.Z - PinWidth*si;
    }
    PinInfo[pin].BX = XZBeg.X;
    PinInfo[pin].BZ = XZBeg.Z;
    PinInfo[pin].EX = XZEnd.X;
    PinInfo[pin].EZ = XZEnd.Z;

    do
    {
      ActIndex++;
      if (XArrayMid[ActIndex + 1] <= XZBeg.X)
      {
        WriteCounter++;
        XArrayPin[WriteCounter] = XArrayMid[ActIndex];
        ZArrayPin[WriteCounter] = ZArrayMid[ActIndex];
      }
      else
      {
        ActIndex--;
        XArrayPin[WriteCounter] = XZBeg.X;
        ZArrayPin[WriteCounter] = XZBeg.Z;
        WriteCounter++;
        XArrayPin[WriteCounter] = XZEnd.X;
        ZArrayPin[WriteCounter] = XZEnd.Z;
        do // set WriteCounter:
        {
          ActIndex++;
        }
        while (XArrayMid[ActIndex + 1] < XZEnd.X);
        Leave = 1;
      }
    }
    while (Leave == 0);
  } // for (pin = 0; pin <= PinNumber/2; pin++)
  ActIndex++;
  for (WriteCounter = ActIndex; ActIndex <= PointsOnLength - 0; ActIndex++)
  {
    WriteCounter++;
    XArrayPin[WriteCounter] = XArrayMid[ActIndex];
    ZArrayPin[WriteCounter] = ZArrayMid[ActIndex];
  }
  for (ActIndex = 0; ActIndex <= PointsOnLength - 1; ActIndex++)
  {
    XArrayPin[ActIndex] = 0.00;
    ZArrayPin[ActIndex] = 0.00;
  }
  WriteCounter = -1; ActIndex = -1; pin = 0;
  do
  {
    ActIndex++;
    if ((XArrayMid[ActIndex] < PinInfo[pin].BX) || (pin == 0.5*PinNumber))
    {
      if (DistanceOK(XArrayMid[ActIndex], ZArrayMid[ActIndex],
              PinInfo[pin].BX, PinInfo[pin].BZ) ||  (pin == 0.5*PinNumber))
      {
        WriteCounter++;
        XArrayPin[WriteCounter] = XArrayMid[ActIndex];
        ZArrayPin[WriteCounter] = ZArrayMid[ActIndex];
      }
    }
    else
    {
      WriteCounter++;
      XArrayPin[WriteCounter] = PinInfo[pin].BX;
      ZArrayPin[WriteCounter] = PinInfo[pin].BZ;
      WriteCounter++;
      XArrayPin[WriteCounter] = PinInfo[pin].EX;
      ZArrayPin[WriteCounter] = PinInfo[pin].EZ;
      do // set WriteCounter:
      {
        ActIndex++;
        if (XArrayMid[ActIndex + 1] > PinInfo[pin].EX)
        {
         if (DistanceOK(XArrayMid[ActIndex + 1], ZArrayMid[ActIndex + 1],
              PinInfo[pin].EX, PinInfo[pin].EZ) || (pin == 0.5*PinNumber))
               Leave = 1;
          else Leave = 0;
        }
        else
        {
          Leave = 0;
        }
      }
      while (!(Leave == 1));
      pin++;
    }
  }
  while (ActIndex <= PointsOnLength - 1);

  for (ActIndex = WriteCounter + 1; ActIndex <= PointsOnLength - 1; ActIndex++)
  {  // fill the rest of the Pin-Arries with zeros:
    XArrayPin[ActIndex] = 0.00;
    ZArrayPin[ActIndex] = 0.00;
  }
}

